
(*********************************************
This is a minimal prototype of an asteroids-like
game.  It illustrates how to subclass TSprite
to create sprites that have specific behaviours.
For example, the TAsteroid class automatically
breaks into chunks of smaller asteroids when it
is destroyed.

The example also shows how to work with multiple
sprite engines, and handle collisions between the
sprite engines.
*********************************************)

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ColorPalette, ThreadTimer, TurboSprite, Missile, StdCtrls, Ship,
  KeyboardHandler, Asteroid, Explosion, Buttons;

type
  TForm1 = class(TForm)
    map: TSpriteSurface;
    ThreadTimer1: TThreadTimer;
    pal: TColorPalette;
    missiles: TSpriteEngine;
    otherSprites: TSpriteEngine;
    keyboard: TKeyboardHandler;
    explosions: TSpriteEngine;
    SpeedButton1: TSpeedButton;
    procedure ThreadTimer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure otherSpritesCollision(Sender: TObject; Sprite,
      TargetSprite: TSprite);
  private
    ship: TShip;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(*********************************************
In the main timer event we poll the keyboard,
using the TKeyboardHandler component.  Take
certain actions based on which keys are pressed.
Finally, call the DIBRefresh method to paint
the screen.
*********************************************)
procedure TForm1.ThreadTimer1Timer(Sender: TObject);
var
  m: TMissile;
begin
{ Rotate the ship }
  if keyboard.KeyDown['k'] then
    ship.Angle := ship.Angle + 8;
  if keyboard.KeyDown['l'] then
    ship.Angle := ship.Angle - 8;
{ Apply thrust if spacebar is pressed }
  if keyboard.KeyDown[' '] then
    ship.Thrust := 0.3
  else
    ship.Thrust := 0;
{ Fire a missile if enter is pressed.  Note, only 6 missiles
  allowed to exist at any one time! }
  if keyboard.VirtualKeyDown[vk_Return] then
  begin
    if missiles.SpriteCount < 6 then
    begin
      m := ship.fire;
      if m <> nil then
        missiles.addSprite( m );
    end;
  end
{ Don't allow him to fire another missile until he lifts his finger
  off off the enter key }
  else
    ship.releaseFire;
{ Paint the screen }
  map.DIBRefresh;
end;

(*********************************************
When the form is created, we create the single
instance of the TShip object, add it to the
SpriteEngine, and set up collision detection so
tests occur only for missiles hitting asteroids
or the ship.
*********************************************)
procedure TForm1.FormCreate(Sender: TObject);
begin
  ship := TShip.CreateShip( MoveThrust, 9 );
  with ship do
  begin
    Position := Point(map.Width div 2, map.Height div 2);
  end;
  otherSprites.addSprite( ship );
  otherSprites.addCollisionEngine( missiles );
end;

(*********************************************
Create a big asteroid when you click on the
button.
*********************************************)
procedure TForm1.Button1Click(Sender: TObject);
var
  ast: TAsteroid;
  c: byte;
{ Give it a random color, but make sure it is bright enough! }
  function sumPalette: integer;
  begin
    with pal do
      Result := PaletteEntry[c].peRed + PaletteEntry[c].peGreen + PaletteEntry[c].peBlue;
  end;
begin
  repeat
    c := Random(255);
  until sumPalette >= 255*2;
  ast := TAsteroid.CreateAsteroid( MoveTowardDestination, c, asBig );
  ast.Position := map.randomPoint;
  ast.Destination := map.randomPoint;
  otherSprites.addSprite( ast );
end;

(*********************************************
This event is triggered when a missile collides
with the ship or an asteroid.  Here we only handle
collisions with the asteroids.  Just setting the
asteroid's "Dead" property to true will kill the
sprite.  And, in the TAsteroid's Destroy method,
it will break into smaller chunks at its current
position.
*********************************************)
procedure TForm1.otherSpritesCollision(Sender: TObject; Sprite,
  TargetSprite: TSprite);
{ Create an explosion at the scene of impact }
  procedure createExplosion;
  var
    exp: TExplosion;
  begin
    exp := TExplosion.CreateExplosion( MoveTowardDestination, Sprite.Position, Random(50) + 50, Random( 255 ) );
    explosions.addSprite( exp );
  end;
begin
{ Only handle collisions with a missile and asteroid ... expand
  this example to handle collisions with the ship if you like! }
  if (Sprite is TAsteroid) then
  begin
    createExplosion;
    Sprite.Dead := true;
    TargetSprite.Dead := true;
  end;
end;

end.
